function gereEImprimaResultado() {
	var quantidade_numeros = parseInt(document.sorteio.quantidade_numeros.value);
	var semente = document.sorteio.semente.value;
	if(isNaN(quantidade_numeros) || quantidade_numeros == 0){
		alert("Informe a Quantidade de Candidatos a Sortear");
	}
	else if(semente == '') {
		alert("Informe a Semente");
	}
	else{
		var listaEmbaralhada = gereListaEmbaralhada(quantidade_numeros, semente);
		imprimaResultado(quantidade_numeros, semente, listaEmbaralhada);
	}	
}

function gereListaEmbaralhada(quantidade_numeros, semente){
	Math.seedrandom(semente);
	var consumida = new Array(quantidade_numeros);
	var resultado = new Array(quantidade_numeros);
	for(var i = 0; i < quantidade_numeros; i++) {
		consumida[i] = 1+i;
		resultado[i] = 0;
	}
	for(var i = 0; i < quantidade_numeros; i++) {
		var aleatorio = Math.floor(Math.random()*quantidade_numeros);
		while(consumida[aleatorio] == 0) {
			aleatorio = (1+aleatorio)%quantidade_numeros;
		}
		resultado[i] = consumida[aleatorio];
		consumida[aleatorio] = 0;
	}
	return resultado;
}

function imprimaResultado(quantidade_numeros, semente, lista) {
	var divResultado = document.getElementById('resultado');
	var conteudo = "<h1>Resultado do Sorteio</h1>";
	conteudo += imprimaLista(lista);
	conteudo += imprimaInformacoesTecnicas(quantidade_numeros, semente, lista);
	divResultado.style.display = 'block';
	divResultado.innerHTML = conteudo;
}

function imprimaLista(lista){
	var conteudo = "";
	for(var i = 0; i < lista.length; i++){
		conteudo += "<div class='item'>";
		conteudo += "  <div class='ordem'>" + (i+1) + "º</div>";
		conteudo += "  <div class='numero'>" + lista[i] + "</div>";
		conteudo += "</div>";
	}
	return conteudo;
}

function imprimaInformacoesTecnicas(quantidade_numeros, semente, lista) {
	var conteudo = "<br/><br/><hr/>";
	conteudo += "<h3>Parâmetros da realização do sorteio</h3>";
	conteudo += "<b>Quantidade de Números Sorteados:</b> " + quantidade_numeros + "<br/>";
	conteudo += "<b>Semente utilizada:</b> " + semente + "<br/>";
	conteudo += "<br/><hr/>";
	conteudo += "<h3>Informações técnicas do ambiente de realização do sorteio</h3>";
	conteudo += "<b>platform:</b> " + navigator.platform + "<br/>";
	conteudo += "<b>appName:</b> " + navigator.appName + "<br/>";
	conteudo += "<b>appVersion:</b> " + navigator.appVersion + "<br/>";
	conteudo += "<b>userAgent:</b> " + navigator.userAgent + "<br/>";
	conteudo += "<br/><hr/>";
	conteudo += "<h3 onclick='document.getElementById(\"json\").style.display == \"none\"?document.getElementById(\"json\").style.display = \"block\":document.getElementById(\"json\").style.display = \"none\";'>Resultado JSON</h3>";
	conteudo += "<div id='json' style='display:none;overflow-wrap: break-word;'>" + listaEmJSON(lista) + "</div>";
	return conteudo;
}

function listaEmJSON(lista){
	var itens = {};
	for(var i = 0; i < lista.length; i++){
		itens[(i+1).toString()] = lista[i].toString() ;
	}
	return JSON.stringify(itens);
}